<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    protected $fillable = [
        'topic_id', 'title', 'image', 'price', 'free',
        'description', 'rating', 'total_review', 'prize',
        'deadline', 'url'
    ];

    public function topic()
    {
        return $this->belongsTo(Topic::class);
    }

    public function mentors()
    {
        return $this->belongsToMany(Mentor::class, 'course_mentor');
    }
}