<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('topic_id')->constrained()->onDelete('cascade')->onUpdate('cascade'); 
            $table->string('title');
            $table->string('image');
            $table->integer('price')->nullable();
            $table->integer('promo')->nullable();
            $table->boolean('free')->default(false);
            $table->string('description');
            $table->decimal('rating', 2, 1);
            $table->integer('total_review');
            $table->string('prize');
            $table->date('deadline')->nullable();
            $table->string('url');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
